/******************************************************************************
*  Serial.C                                   *
*
*   Low Level Serial Routines for Serial Port 1                                                                         
*    
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.       
*                                                                            
******************************************************************************/

#include "LPC17xx.h"             /* LPC21xx definitions               */
#include "command.h"
#define CR     0x0D				 /* ASCII Carraige return */ 

unsigned char temp_char;

unsigned char int_id;
unsigned char int_source;

unsigned char rcv_buf;
extern unsigned char proc_cmd;


#define USE_UART1                                  

/* If UART 0 is used  */
#ifdef USE_UART0
  #define UxFDR  UART0->FDR
  #define UxLCR  UART0->LCR
  #define UxDLL  UART0->DLL
  #define UxDLM  UART0->DLM
  #define UxLSR  UART0->LSR
  #define UxTHR  UART0->THR
  #define UxRBR  UART0->RBR
  #define UxIER	 UART0->IER
/* If UART 1 is used  */
#elif defined(USE_UART1)
  #define UxFDR  UART1->FDR
  #define UxLCR  UART1->LCR
  #define UxDLL  UART1->DLL
  #define UxDLM  UART1->DLM
  #define UxLSR  UART1->LSR
  #define UxTHR  UART1->THR
  #define UxRBR  UART1->RBR
  #define UxIER	 UART1->IER
#endif


void init_serial (void)  {               // Initialize Serial Interface       
  #ifdef USE_UART0
    PINCON->PINSEL0 |= 0x00000050;       // Enable TxD0 and RxD0             
  #elif defined (USE_UART1)
    PINCON->PINSEL4 = 0x0000000A;        // Enable TxD1 and RxD1 om P2.0 and P2.1             
  #endif
  UxFDR = 0xA7;                       // Fractional divider 38.4K @24mhz
  UxLCR = 0x83;                       // 8 bits, no Parity, 1 Stop bit       
  UxDLL = 23;                         // 38.4k Baud Rate @ 24 MHZ PCLK    
  UxDLM = 0;                          // High divisor latch = 0            
  UxLCR = 0x03;                       // DLAB = 0                         
  UxIER = 0x05;			  			  // Enable U1RBR Interrupt
}


char putchar (char ch)  	   // Write character to Serial Port    
{                  
  if (ch == '\n')  
  {
    while (!(UxLSR & 0x20));
    UxTHR = CR;                     // output CR 
  }
  while (!(UxLSR & 0x20));
  return(UxTHR = ch);
}

char getchar (void)  {                    // Read character from Serial Port   

  while (!(UxLSR & 0x01));
  return (UxRBR);
}

 void puthex (char hex) {                    // Write Hex Digit to Serial Port  
  if (hex > 9) putchar('A' + (hex - 10));
  else         putchar('0' +  hex);
}

void putstr (char *p) {                    // Write string 
  while (*p) {
    putchar (*p++);
  }
}

void put_long_hex (long value) 
{
  putstr ("0x");
  puthex((value >> 28) & 0x0F);		 // Write Hex Digits
  puthex((value >> 24) & 0x0F);
  puthex((value >> 20) & 0x0F);
  puthex((value >>16) & 0x0F);           
  puthex((value >>12) & 0x0F);
  puthex((value >> 8) & 0x0F);              
  puthex((value >> 4) & 0x0F);               
  puthex (value & 0x0F);
 }
                     
void UART1_IRQHandler(void)
{
  int_id = UART1->IIR;			// read int ID
  int_source = UART1->LSR;
  temp_char=getchar ();
  Menu(temp_char);			 //get menu and set flags (see commands.c)
}

